/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.globalsetting;

import com.tp_link.eap.domain.globalsetting.bean.RateLimit;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Ssid {
    @Id
    private String id;
    private Integer idInt;
    private int radioId;
    @Length(min=1, max=32, message="Length of SSID name is from 1 to 32.")
    private String name;
    private String band;
    @Range(min=0L, max=4094L, message="Value of Vlan ID is from 0 to 4094.")
    private Integer vlanId;
    private Boolean broadcast;
    @Range(min=0L, max=3L, message="Value of Security Mode is from 0 to 3.")
    private Integer securityMode;
    private String portalId;
    private Boolean isolation;
    @Range(min=0L, max=3L, message="Value of Version is from 1 to 3.")
    private Integer versionEnt = 0;
    @Range(min=0L, max=3L, message="Value of Encryption is from 1 to 3")
    private Integer encryptionEnt = 0;
    @Pattern(regexp="^$|\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Value of Radius Server Ip should be correct ip address.")
    private String radiusServerIp;
    @Range(min=0L, max=65535L, message="Value of Radius Port is form 0 to 65535.")
    private Integer radiusPort;
    @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{1,63}|[0-9a-fA-F]{1,64})$", message="Not support '+#&=|<>^\\' in this field.")
    private String radiusPasswordEnt;
    private Integer updatePeriodEnt;
    @Range(min=0L, max=3L, message="Value of Version is from 1 to 3.")
    private Integer versionPsk = 0;
    @Range(min=0L, max=3L, message="Value of Encryption is from 1 to 3")
    private Integer encryptionPsk = 0;
    @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{8,63}|[0-9a-fA-F]{8,64})$", message="Not support '+#&=|<>^\\' in this field.")
    private String wirelessPasswordPsk;
    private Integer updatePeriodPsk;
    @Range(min=1L, max=3L, message="Value of WEP Type is from 1 to 3.")
    private Integer wepMode = 1;
    @Range(min=1L, max=4L, message="Value of Key Select is from 1 to 4.")
    private Integer wepKeyIndex = 1;
    @Range(min=1L, max=2L, message="Value of WEP Key Format is from 1 to 2.")
    private Integer wepKeyFormat1 = 1;
    @Range(min=1L, max=2L, message="Value of WEP Key Format is from 1 to 2.")
    private Integer wepKeyFormat2 = 1;
    @Range(min=1L, max=2L, message="Value of WEP Key Format is from 1 to 2.")
    private Integer wepKeyFormat3 = 1;
    @Range(min=1L, max=2L, message="Value of WEP Key Format is from 1 to 2.")
    private Integer wepKeyFormat4 = 1;
    private Integer wepKeyType1 = 5;
    private Integer wepKeyType2 = 5;
    private Integer wepKeyType3 = 5;
    private Integer wepKeyType4 = 5;
    private String wepKeyValue1;
    private String wepKeyValue2;
    private String wepKeyValue3;
    private String wepKeyValue4;
    private Integer macFilterId;
    @Transient
    private String filterName;
    private Boolean filteringAction;
    private Integer schedulerId;
    @Transient
    private String schedulerName;
    private Boolean schedulerAction;
    private RateLimit rateLimit;
    private Boolean accessControl;
    @Indexed
    private String accessControlRule;
    private String accessControlRuleName;
    @Indexed
    private String site;
    private String wlanId;
    @Transient
    private String wlanName;
    private Boolean portalEnable;

    public Boolean getPortalEnable() {
        return this.portalEnable;
    }

    public void setPortalEnable(Boolean portalEnable) {
        this.portalEnable = portalEnable;
    }

    public String getWlanId() {
        return this.wlanId;
    }

    public void setWlanId(String wlanId) {
        this.wlanId = wlanId;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getIdInt() {
        return this.idInt;
    }

    public void setIdInt(Integer idInt) {
        this.idInt = idInt;
    }

    public int getRadioId() {
        return this.radioId;
    }

    public void setRadioId(int radioId) {
        this.radioId = radioId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVlanId() {
        return this.vlanId;
    }

    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    public Boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    public Boolean portalIdExist() {
        return this.portalId != null;
    }

    public Boolean getIsolation() {
        return this.isolation;
    }

    public void setIsolation(Boolean isolation) {
        this.isolation = isolation;
    }

    public Integer getVersionEnt() {
        return this.versionEnt;
    }

    public void setVersionEnt(Integer versionEnt) {
        this.versionEnt = versionEnt;
    }

    public Integer getEncryptionEnt() {
        return this.encryptionEnt;
    }

    public void setEncryptionEnt(Integer encryptionEnt) {
        this.encryptionEnt = encryptionEnt;
    }

    public String getRadiusServerIp() {
        return this.radiusServerIp;
    }

    public void setRadiusServerIp(String radiusServerIp) {
        this.radiusServerIp = radiusServerIp;
    }

    public Integer getRadiusPort() {
        return this.radiusPort;
    }

    public void setRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
    }

    public String getRadiusPasswordEnt() {
        return this.radiusPasswordEnt;
    }

    public void setRadiusPasswordEnt(String radiusPasswordEnt) {
        this.radiusPasswordEnt = radiusPasswordEnt;
    }

    public Integer getUpdatePeriodEnt() {
        return this.updatePeriodEnt;
    }

    public void setUpdatePeriodEnt(Integer updatePeriodEnt) {
        this.updatePeriodEnt = updatePeriodEnt;
    }

    public Integer getVersionPsk() {
        return this.versionPsk;
    }

    public void setVersionPsk(Integer versionPsk) {
        this.versionPsk = versionPsk;
    }

    public Integer getEncryptionPsk() {
        return this.encryptionPsk;
    }

    public void setEncryptionPsk(Integer encryptionPsk) {
        this.encryptionPsk = encryptionPsk;
    }

    public String getWirelessPasswordPsk() {
        return this.wirelessPasswordPsk;
    }

    public void setWirelessPasswordPsk(String wirelessPasswordPsk) {
        this.wirelessPasswordPsk = wirelessPasswordPsk;
    }

    public Integer getUpdatePeriodPsk() {
        return this.updatePeriodPsk;
    }

    public void setUpdatePeriodPsk(Integer updatePeriodPsk) {
        this.updatePeriodPsk = updatePeriodPsk;
    }

    public Integer getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(Integer securityMode) {
        this.securityMode = securityMode;
    }

    public String getBand() {
        return this.band;
    }

    public void setBand(String band) {
        this.band = band;
    }

    public Integer getMacFilterId() {
        return this.macFilterId;
    }

    public void setMacFilterId(Integer macFilterId) {
        this.macFilterId = macFilterId;
    }

    public Boolean getFilteringAction() {
        return this.filteringAction;
    }

    public void setFilteringAction(Boolean filteringAction) {
        this.filteringAction = filteringAction;
    }

    public Integer getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(Integer schedulerId) {
        this.schedulerId = schedulerId;
    }

    public Boolean getSchedulerAction() {
        return this.schedulerAction;
    }

    public void setSchedulerAction(Boolean schedulerAction) {
        this.schedulerAction = schedulerAction;
    }

    public Integer getWepMode() {
        return this.wepMode;
    }

    public void setWepMode(Integer wepMode) {
        this.wepMode = wepMode;
    }

    public Integer getWepKeyIndex() {
        return this.wepKeyIndex;
    }

    public void setWepKeyIndex(Integer wepKeyIndex) {
        this.wepKeyIndex = wepKeyIndex;
    }

    public Integer getWepKeyFormat1() {
        return this.wepKeyFormat1;
    }

    public void setWepKeyFormat1(Integer wepKeyFormat1) {
        this.wepKeyFormat1 = wepKeyFormat1;
    }

    public Integer getWepKeyFormat2() {
        return this.wepKeyFormat2;
    }

    public void setWepKeyFormat2(Integer wepKeyFormat2) {
        this.wepKeyFormat2 = wepKeyFormat2;
    }

    public Integer getWepKeyFormat3() {
        return this.wepKeyFormat3;
    }

    public void setWepKeyFormat3(Integer wepKeyFormat3) {
        this.wepKeyFormat3 = wepKeyFormat3;
    }

    public Integer getWepKeyFormat4() {
        return this.wepKeyFormat4;
    }

    public void setWepKeyFormat4(Integer wepKeyFormat4) {
        this.wepKeyFormat4 = wepKeyFormat4;
    }

    public Integer getWepKeyType1() {
        return this.wepKeyType1;
    }

    public void setWepKeyType1(Integer wepKeyType1) {
        this.wepKeyType1 = wepKeyType1;
    }

    public Integer getWepKeyType2() {
        return this.wepKeyType2;
    }

    public void setWepKeyType2(Integer wepKeyType2) {
        this.wepKeyType2 = wepKeyType2;
    }

    public Integer getWepKeyType3() {
        return this.wepKeyType3;
    }

    public void setWepKeyType3(Integer wepKeyType3) {
        this.wepKeyType3 = wepKeyType3;
    }

    public Integer getWepKeyType4() {
        return this.wepKeyType4;
    }

    public void setWepKeyType4(Integer wepKeyType4) {
        this.wepKeyType4 = wepKeyType4;
    }

    public String getWepKeyValue1() {
        return this.wepKeyValue1;
    }

    public void setWepKeyValue1(String wepKeyValue1) {
        this.wepKeyValue1 = wepKeyValue1;
    }

    public String getWepKeyValue2() {
        return this.wepKeyValue2;
    }

    public void setWepKeyValue2(String wepKeyValue2) {
        this.wepKeyValue2 = wepKeyValue2;
    }

    public String getWepKeyValue3() {
        return this.wepKeyValue3;
    }

    public void setWepKeyValue3(String wepKeyValue3) {
        this.wepKeyValue3 = wepKeyValue3;
    }

    public String getWepKeyValue4() {
        return this.wepKeyValue4;
    }

    public void setWepKeyValue4(String wepKeyValue4) {
        this.wepKeyValue4 = wepKeyValue4;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(RateLimit rateLimit) {
        this.rateLimit = rateLimit;
    }

    public Boolean getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(Boolean accessControl) {
        this.accessControl = accessControl;
    }

    public String getAccessControlRule() {
        return this.accessControlRule;
    }

    public void setAccessControlRule(String accessControlRule) {
        this.accessControlRule = accessControlRule;
    }

    public String getAccessControlRuleName() {
        return this.accessControlRuleName;
    }

    public void setAccessControlRuleName(String accessControlRuleName) {
        this.accessControlRuleName = accessControlRuleName;
    }

    public String getWlanName() {
        return this.wlanName;
    }

    public void setWlanName(String wlanName) {
        this.wlanName = wlanName;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getPortalId() {
        return this.portalId;
    }

    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }
}

